<?php
error_reporting(E_ALL ^ E_NOTICE);
// Permite la conexion desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecucion de los metodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';
$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$sql = "SELECT K.producto_id, K.codigo_producto, P.nombre AS descripcion, K.fecha_traslado, If(K.entrada>0,'E','S') AS tipo,
    If(K.entrada>0,'02','01') AS tipo10, DF.codigo_sunat AS tipo12, K.entrada, TRUNCATE((K.entrada/P.capacidad),0) AS Ent_Und,
    If(K.capacidad_precio=P.capacidad,K.unidad_medida,'') AS AbreE_Und, (K.entrada-TRUNCATE((K.entrada/P.capacidad),0)*P.capacidad) AS Ent_Fra,
    If(K.capacidad_precio<P.capacidad,K.unidad_medida,'') AS AbreE_Fra, K.costo,
    K.salida, TRUNCATE((K.salida/P.capacidad),0) AS Vta_Und, If(K.capacidad_precio=P.capacidad,K.unidad_medida,'') AS AbreV_Und,
    (K.salida-TRUNCATE((K.salida/P.capacidad),0)*P.capacidad) AS Vta_Fra, If(K.capacidad_precio<P.capacidad,K.unidad_medida,'') AS AbreV_Fra, K.precio_venta,
    K.nserie, K.ndocumento, P.capacidad, K.recogido, P.precio_stock, (P.precio_stock/P.capacidad) AS precio_unidad from kardex AS K 
    INNER JOIN productos AS P ON K.producto_id = P.id 
    INNER JOIN docfiscales AS DF ON K.docfiscal_id = DF.id
    WHERE K.empresa_id = $datos[0] AND K.almacen_id = $datos[1] AND K.producto_id = $datos[2] and K.anulado = 0
    ORDER BY K.producto_id, K.fecha_traslado, Entrada Desc";

$rows = array();

/*print_r("Filtro",'$datos[0]')*/

if ($result = mysqli_query($conn, $sql)) {
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        mysqli_free_result($result);
    } else {
        //echo "No records matching your query were found.";
        print_json([]);
    }
} else {
    echo "ERROR: Could not able to execute the query."; // . mysqli_error($this->conn);
}
// Cerrar la conexión a la base de datos
mysqli_close($conn);

print_json($rows);
function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    	
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            //  echo ' - No errors';
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
	}
}

?>