<?php
error_reporting(E_ALL ^ E_NOTICE);
// Permite la conexion desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permite la ejecucion de los metodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
// Se incluye el archivo que contiene la clase generica
include_once '../conexion.php';
$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

// echo "Receividos del cliente:";
// print_r($datos);
/*
$sql = "SELECT K.producto_id, K.codigo_producto, P.nombre AS descripcion, Sum(If(K.entrada>0,K.entrada,-K.salida)) AS stock_actual,
 TRUNCATE((Sum(If(K.entrada>0,K.entrada,-K.salida))/P.capacidad),0) AS stock_und, U.abrev As und_med,
 (Sum(If(K.entrada>0,K.entrada,-K.salida))-(TRUNCATE((Sum(If(K.entrada>0,K.entrada,-K.salida))/P.capacidad),0)*P.capacidad)) AS stock_fra, F.abrev As fra_med,
 P.capacidad, C.nombre as categoria, M.nombre as marca, P.precio_stock, (P.precio_stock/P.capacidad) AS precio_unidad
 from kardex AS K inner join productos AS P on K.producto_id = P.id
 inner join unidadmedida as U on P.unidad_id = U.id INNER JOIN unidadmedida AS F ON P.fraccion_id = F.id
 INNER JOIN categorias AS C ON P.categoria_id = C.id INNER JOIN marcas AS M ON P.marca_id = M.id.'$datos[0]'.GROUP BY K.producto_id, K.codigo_producto, P.nombre, P.capacidad"
*/

$sql = "SELECT K.producto_id, P.codigo_producto, P.nombre AS descripcion, 
        Sum(If(K.entrada>0, K.entrada, -K.salida)) AS stock_actual,
        TRUNCATE((Sum(If(K.entrada>0, K.entrada, -K.salida))/P.capacidad),0) AS stock_und, 
        U.abrev As und_med,
        (Sum(If(K.entrada>0, K.entrada, -K.salida))-(TRUNCATE((Sum(If(K.entrada>0, K.entrada, -K.salida))/P.capacidad),0)*P.capacidad)) AS stock_fra, 
        F.abrev As fra_med,
        P.capacidad, C.nombre as categoria, M.nombre as marca, P.precio_stock, 
        (P.precio_stock/P.capacidad) AS precio_unidad
        FROM kardex AS K 
        INNER JOIN productos AS P ON K.producto_id = P.id
        INNER JOIN unidadmedida as U ON P.unidad_id = U.id 
        INNER JOIN unidadmedida AS F ON P.fraccion_id = F.id
        INNER JOIN categorias AS C ON P.categoria_id = C.id 
        INNER JOIN marcas AS M ON P.marca_id = M.id
        WHERE {$datos[0]} GROUP BY K.producto_id, P.codigo_producto, P.nombre, P.capacidad";

$rows = array();

/*print_r("Filtro",'$datos[0]')*/

if ($result = mysqli_query($conn, $sql)) {
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        mysqli_free_result($result);
    } else {
        //echo "No records matching your query were found.";
        print_json([]);
    }
} else {
    echo "ERROR: Could not able to execute the query."; // . mysqli_error($this->conn);
}
// Cerrar la conexión a la base de datos
mysqli_close($conn);

print_json($rows);
function print_json($data) {
    header("Content-type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    	
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            //  echo ' - No errors';
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
	}
}

?>