<?php
include_once '../conexion.php';

// Obtener los datos combinados del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true);

// Iniciar la transacción
mysqli_autocommit($conn, false);
// Variable para verificar el estado de la transacción
$transaccionExitosa = true;
$errorMensaje = "";

try {
     // Acceder a los valores individuales de los datos combinados
     $cEmpresa_Id = $data['Empresa_id'];
     $cDocFiscal_id = $data['DocFiscal_Id'];
     $cNSerie = $data['NSerie'];
     $cNDocumento = $data['NDocumento'];
     $cFechaEmision = $data['Fecha_Emision'];
     $cFechaTraslado = $data['Fecha_Traslado'];
     $cFechaVencimiento = $data['Fecha_Vcto'];
     $cNombre = $data['Razon_Social'];
     $cDireccion = $data['Direccion'];
     $cTipDocIdent = $data['Tipo_Documento'];
     $cDocIdentidad = $data['DocIdentidad'];
     $cNDias = $data['NDias'];
     $cMoneda = $data['Moneda'];
     $cTipoCambio = $data['Tipo_Cambio'];
     $cAfectoIgv = $data['Afecto_IGV'];
     $cP_Igv = $data['pIGV'];
     $cIgv = $data['IGV'];
     $cAfectDscto = $data['Descuento'];
     $cP_Dscto = $data['pDSCTO'];
     $cDescuento = $data['Descuento'];
     $cAfectoPercepcion = $data['Afecto_Percepcion'];
     $cP_Percepcion = $data['pPercepcion'];
     $cPercepcion = $data['Percepcion'];
     $cAfecto = $data['Valor_Venta'];
     $cInafecto = $data['Inafecto'];
     $cExonerado = $data['Exonerada'];
     $cTotal = $data['Total_Pagar'];
     $cGuiaRemision = $data['NGuiaRemision'];
     $cCancelado = $data['Cancelado'];
     $cIcbp = $data['ICBPER'];
     $cGratuitas = $data['Gratuitas'];
     $cAfectaKardex = $data['Afecta_Kardex'];
     $cAfectaCaja = $data['Afecta_Caja'];
     $cPeriodo = $data['Periodo'];
     $cMes = $data['Mes'];
     $cFormaPago_Id = $data['Forma_Pago'];
     $cCaja_Id = $data['Caja_Id'];
     $cCliente_Id = $data['Cliente_Id'];
     $cEmpleado_id = $data['Empleado_Id'];
     $cSucursal_Id = $data['Sucursal_Id'];
     $cObservacion = $data['Observacion'];
     //$cServicio = $data['Servicio'];
     //$cZona_Id = $data['Zona_Id'];
     $iIProf_M = $data['IdProf_M'];
     $cEstado = $data['Estado'];
          
    if ($cEstado == 'NUEVO') {

        // Ejemplo de inserción en la tabla proforma
        $queryCabecera = "INSERT INTO proformas(empresa_id, docfiscal_id, nserie, ndocumento, fecha_emision, fecha_traslado, fecha_vencimiento, 
        razon_social, direccion, tipo_docidentidad, documento_identidad, nro_dias, moneda, tipo_cambio, afecto_igv, 
        porcentaje_igv, igv, afecto_dscto, porcentaje_dscto, descuento, afecto_percepcion, porcentaje_percepcion, percepcion,
        afecto, inafecto, exonerado, total, guia_remision, cancelado, icbp, gratuitas, afecta_kardex, afecta_caja, periodo, mes, 
        formapago_id, caja_id, cliente_id, empleado_id, sucursal_id, observacion)
        VALUES ('$cEmpresa_Id', '$cDocFiscal_id', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cFechaVencimiento', 
        '$cNombre', '$cDireccion', '$cTipDocIdent', '$cDocIdentidad', '$cNDias', '$cMoneda', '$cTipoCambio', '$cAfectoIgv', '$cP_Igv', '$cIgv', 
        '$cAfectDscto', '$cP_Dscto', '$cDescuento', '$cAfectoPercepcion', '$cP_Percepcion', '$cPercepcion', '$cAfecto', '$cInafecto',
        '$cExonerado', '$cTotal', '$cGuiaRemision', '$cCancelado', '$cIcbp', '$cGratuitas', '$cAfectaKardex', '$cAfectaCaja', '$cPeriodo', '$cMes', 
        '$cFormaPago_Id', '$cCaja_Id', '$cCliente_Id', '$cEmpleado_id', '$cSucursal_Id', '$cObservacion')";

        $resultadoCabecera = mysqli_query($conn, $queryCabecera);
        if (!$resultadoCabecera) {
            throw new Exception(mysqli_error($conn));
        }

        // Obtener el ID del último registro insertado en la cabecera de ventas
        $idProforma = mysqli_insert_id($conn);

        // ACTUALIZA REGISTRO DE SERIES
        $query = "SELECT numero FROM series_sucursal WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
           AND nserie = '$cNSerie' FOR UPDATE";
        $result = mysqli_query($conn, $query);
        if (!$result) {
            throw new Exception(mysqli_error($conn));
        }

        $queryUPD = "UPDATE series_sucursal SET numero = numero + 1 WHERE empresa_id = $cEmpresa_Id AND sucursal_id = $cSucursal_Id 
          AND nserie = '$cNSerie'";
        $resultUPD = mysqli_query($conn, $queryUPD);  
        if (!$resultUPD) {
            throw new Exception(mysqli_error($conn));
        }

        // Ejemplo de inserción en la tabla detalle
        foreach ($data['detalle'] as $detalle_) {
            $cAlmacen_Id = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            $cMargen = $detalle_['margen'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            // $cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cModelo_Id = $detalle_['modelo_id'];

            $queryDetalle = "INSERT INTO detproformas (proforma_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
             bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
             precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, margen, costo, peso, 
             porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, categoria_id, marca_id,
             modelo_id, empresa_id, sucursal_id) 
            VALUES ('$idProforma', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacen_Id', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cMargen', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cCategoria_Id', '$cMarca_Id',
            '$cModelo_Id', '$cEmpresa_Id', '$cSucursal_Id')";
            
            $resultadoDetalle = mysqli_query($conn, $queryDetalle);
            if (!$resultadoDetalle) {
                throw new Exception(mysqli_error($conn));
            }
            
        }

    } elseif ($cEstado == 'MODIFICAR') { 
        $queryUpd_DetProf = "UPDATE detproformas SET IUD = 'D' WHERE proforma_id = $iIProf_M";
        $resultadoUpd_DetProf = mysqli_query($conn, $queryUpd_DetProf);        
        if (!$resultadoUpd_DetProf) {
            throw new Exception(mysqli_error($conn));
        }
        
        $queryUpd_Proformas = "UPDATE proformas SET empresa_id = '$cEmpresa_Id', docfiscal_id = '$cDocFiscal_id', nserie = '$cNSerie', ndocumento = '$cNDocumento', 
             fecha_emision = '$cFechaEmision', fecha_traslado = '$cFechaTraslado', fecha_vencimiento = '$cFechaVencimiento', razon_social = '$cNombre',
             direccion = '$cDireccion', tipo_docidentidad = '$cTipDocIdent', documento_identidad = '$cDocIdentidad', nro_dias = '$cNDias', 
             moneda = '$cMoneda', tipo_cambio = '$cTipoCambio', afecto_igv = '$cAfectoIgv', porcentaje_igv = '$cP_Igv', igv = '$cIgv', 
             afecto_dscto = '$cAfectDscto', porcentaje_dscto = '$cP_Dscto', descuento = '$cDescuento', afecto_percepcion = '$cAfectoPercepcion', 
             porcentaje_percepcion = '$cP_Percepcion', percepcion = $cPercepcion, afecto = '$cAfecto', inafecto = '$cInafecto', exonerado = '$cExonerado',
             total = '$cTotal', guia_remision = '$cGuiaRemision', cancelado = '$cCancelado', icbp = '$cIcbp', gratuitas = '$cGratuitas', 
             afecta_kardex = '$cAfectaKardex', afecta_caja = $cAfectaCaja, periodo = '$cPeriodo', mes = '$cMes', formapago_id = '$cFormaPago_Id',
             caja_id = '$cCaja_Id', cliente_id = '$cCliente_Id', empleado_id = '$cEmpleado_id', sucursal_id = '$cSucursal_Id', observacion = '$cObservacion'
           WHERE id = $iIProf_M";
        
        $resultadoUpd_Proformas = mysqli_query($conn, $queryUpd_Proformas);        
        if (!$resultadoUpd_Proformas) {
            throw new Exception(mysqli_error($conn));
        }
           
         // Ejemplo de inserción en la tabla detalle  foreach ($data['ventas'] as $detalle_) {
        foreach ($data['detalle'] as $detalle_) {
            $cAlmacen_Id = $detalle_['almacen_id'];
            $cProducto_Id = $detalle_['producto_id'];
            $cBonificdProd = $detalle_['bonificacion'];
            $cCodProd = $detalle_['codigo_producto'];
            $cCantidad = $detalle_['cantidad'];
            $cRecogido = $detalle_['recogido'];
            $cCapacidad_Precio = $detalle_['capacidad_precio'];
            $cDescrip_Precio = $detalle_['descrip_precio'];
            $cPrecio_Bruto = $detalle_['precio_bruto'];
            $cDescuento = $detalle_['descuento'];
            $cPrecio = $detalle_['precio'];
            $cPrecioigv = $detalle_['precioigv'];
            $cIgv = $detalle_['igv'];
            $cPercepcion = $detalle_['percepcion'];
            $cAfecto = $detalle_['afecto'];
            $cInafecto = $detalle_['inafecto'];
            $cExonerado = $detalle_['exonerado'];
            $cSubtotal = $detalle_['subtotal'];
            $cSubtotaligv = $detalle_['subtotaligv'];
            $cMargen = $detalle_['margen'];
            $cCosto = $detalle_['costo'];
            $cPeso = $detalle_['peso'];
            $cPorcentaje_Igv = $detalle_['porcentaje_igv'];
            $cIcbp = $detalle_['icbp'];
            $cDescripcion_Servicio = $detalle_['descripcion_servicio'];
            $cVencimiento = $detalle_['vencimiento'];
            $cLote = $detalle_['lote'];
            $cAbrev_Universal = $detalle_['abrev_universal'];
            $cRazon_Social = $cNombre;
            //$cObservacion = $cObservacion;
            $cIdDocFis = $cDocFiscal_id;
            $cCategoria_Id = $detalle_['categoria_id'];
            $cMarca_Id = $detalle_['marca_id'];
            $cModelo_Id = $detalle_['modelo_id'];

            $queryDetalle = "INSERT INTO detproformas (proforma_id, nserie, ndocumento, fecha_emision, fecha_traslado, almacen_id, producto_id,
             bonificacion, codigo_producto, cantidad, recogido, capacidad_precio, descrip_precio, precio_bruto, descuento, precio, 
             precioigv, igv, percepcion, afecto, inafecto, exonerado, subtotal, subtotaligv, margen, costo, peso, 
             porcentaje_igv, icbp, descripcion_servicio, vencimiento, lote, abrev_universal, categoria_id, marca_id,
             modelo_id, empresa_id, sucursal_id) 
            VALUES ('$iIProf_M', '$cNSerie', '$cNDocumento', '$cFechaEmision', '$cFechaTraslado', '$cAlmacen_Id', '$cProducto_Id', 
            '$cBonificdProd', '$cCodProd', '$cCantidad', '$cRecogido', '$cCapacidad_Precio', '$cDescrip_Precio', '$cPrecio_Bruto', '$cDescuento', '$cPrecio', 
            '$cPrecioigv', '$cIgv', '$cPercepcion', '$cAfecto', '$cInafecto', '$cExonerado', '$cSubtotal', '$cSubtotaligv', '$cMargen', '$cCosto', '$cPeso', 
            '$cPorcentaje_Igv', '$cIcbp', '$cDescripcion_Servicio', '$cVencimiento', '$cLote', '$cAbrev_Universal', '$cCategoria_Id', '$cMarca_Id',
            '$cModelo_Id', '$cEmpresa_Id', '$cSucursal_Id')";
            $resultadoDetalle = mysqli_query($conn, $queryDetalle);

            if (!$resultadoDetalle) {
                throw new Exception(mysqli_error($conn));
            }

        }
        
        //Elimina Detalle de Proforma para Evitar la Duplicidad
        $queryDelProf = "DELETE FROM detproformas WHERE proforma_id = $iIProf_M AND IUD = 'D'";
        $resultadoDelProf = mysqli_query($conn, $queryDelProf);        
        if (!$resultadoDelProf) {
           throw new Exception(mysqli_error($conn));
        }

    }

    // Confirmar la transacción
    mysqli_commit($conn);
    
} catch (Exception $e) {
    // Revertir la transacción en caso de error
    mysqli_rollback($conn);
    $transaccionExitosa = false;
    $errorMensaje = $e->getMessage();
}

// Cerrar la conexión a la base de datos
mysqli_close($conn);

// Enviar una respuesta al cliente
if ($transaccionExitosa) {
    $response = array();
    //$response = array("ESTADO" => "00", "MENSAJE" => "Los datos se han guardado correctamente");
    if ($cEstado == 'NUEVO') {
        if ($idProforma > 0) {
            //$response = array();
            $response['ESTADO'] = "00";
            $response['ID'] = $idProforma;
            $response['MENSAJE'] = "Los datos se han guardado correctamente";
        } else {
            //$response = array();
            $response['ESTADO'] = "11";
            $response['ID'] = 0;
            $response['MENSAJE'] = "Error al guardar la información: " . $errorMensaje;
        }
    } else {
        //$response = array();
        $response['ESTADO'] = "00";
        $response['ID'] = $iIProf_M;
        $response['MENSAJE'] = "Los datos se actualizaron correctamente";
    }
} else {
    //$response = array("ESTADO" => "11", "MENSAJE" => "Error al guardar la información: " . $errorMensaje);
    $response = array();
    $response['ESTADO'] = "111";
    $response['ID'] = 0;
    $response['MENSAJE'] = "Error al guardar la información: " . $errorMensaje;
}
echo json_encode($response);

?>


